//
//  GameBoardViewController.h
//  RoadTripBingo
//
//  Created by Juan Navas Martin on 2/15/14.
//  Copyright (c) 2014 Juan Navas. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <QuartzCore/QuartzCore.h>

#import "TrafficSignCell.h"
#import "RTBSign.h"
#import "GameDetailsDAO.h"
#import "RTBGame.h"
#import "RTBGameDAO.h"
#import "TSDetailsViewController.h"
#import "UIColor+RTBColors.h"



@interface GameBoardViewController : UIViewController <UICollectionViewDataSource, UICollectionViewDelegate, TSDetailsViewControllerDelegate>

- (IBAction)backButton:(id)sender;
@property (weak, nonatomic) IBOutlet UILabel *gameTimerLabel;
@property (weak, nonatomic) IBOutlet UILabel *playerNameLabel;
@property (weak, nonatomic) IBOutlet UILabel *lineLabel;
@property (weak, nonatomic) IBOutlet UILabel *totalLabel;
@property (weak, nonatomic) IBOutlet UICollectionView *collectionView;

@property NSMutableArray *tSigns;
@property (strong, nonatomic) RTBSign *selectedTS;
@property (strong, nonatomic) RTBGame *currentGame;

int maxValueOfArray(int myArray[], size_t size);

- (void)updateTimerLabel;

@end
